<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Koyel Grid
 */
 $koyel_grid_column_settings  = get_theme_mod('koyel_grid_column_settings','4');
if ( ! is_singular( ) ) : ?>
<div class="col-lg-<?php echo esc_html( $koyel_grid_column_settings ); ?>">	
<?php endif; ?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php
	if ( 'post' === get_post_type() ) : ?>
		<?php if(! is_single()): ?>
		<div class="entry-meta">
			<?php koyel_grid_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php endif; 
		 if (is_singular()){
			koyel_grid_single_cat(); 
		}
	endif; ?>
	<header class="entry-header">
		<?php
		if ( is_singular() ) :
			the_title( '<h1 class="single-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif; ?>
	</header><!-- .entry-header -->
	<?php if (is_single()) : ?>
		<?php if ( has_post_thumbnail () ): ?>
		<div class="single-area-img">
			<?php koyel_post_thumbnail(); ?>
		</div>
		<?php endif; ?>
		<div class="single-entry-meta">
			<?php koyel_grid_posted_by(); ?><span class="line">/</span><?php  koyel_grid_posted_on(); ?><span class="line">/</span><?php koyel_grid_single_comment(); ?>
		</div>
	<?php endif; ?>
	<?php if ( ! is_single()) : ?>
	<div class="single-img">
		<?php if ( has_post_thumbnail () ):
            koyel_post_thumbnail(); 
        endif; ?>
	</div>
	<?php endif; ?>
	<div class="entry-content <?php if ( ! has_post_thumbnail () && is_single() ): ?>padding-top<?php endif; ?>">
		<?php

		if(is_single( )){
			the_content(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'koyel-grid' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post( get_the_title() )
				)
			);
		}else{
			the_excerpt();
		}
		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'koyel-grid' ),
				'after'  => '</div>',
			)
		);
		?>
	</div><!-- .entry-content -->
</article><!-- #post-<?php the_ID(); ?> -->
<?php if ( ! is_singular( ) ) : ?>
</div>	
<?php endif;