<?php
/**
 * Koyel Theme Customizer
 *
 * @package Koyel
 */

//Sanitize Blog Layout Select Box
function koyel_grid_sanitize_style_select_box($value){ 
    if(!in_array($value, array('6','4'))){
        $value = '4';
    }
    return $value;
}

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function koyel_grid_customize_register( $wp_customize ) {
    // Add koyel blogpage options section
    $wp_customize->add_section('koyel_grid_blogpage_options', array(
        'title'          => esc_html__('Blogpage Settings', 'koyel'),
        'capability'     => 'edit_theme_options',
        'description'    => esc_html__('Select blog settings from here.', 'koyel'),
        'priority'       => 20,
    ));
    // Column Settings
    $wp_customize->add_setting('koyel_grid_column_settings', array(
        'default'           => '4',
        'capability'        => 'edit_theme_options',
        'type'              => 'theme_mod',
        'sanitize_callback' => 'koyel_grid_sanitize_style_select_box',
        'transport'         => 'refresh',
    ));
    $wp_customize->add_control('koyel_grid_column_control', array(
        'label'             => esc_html__('Select blog column', 'koyel'),
        'description'       => esc_html__('Select blog column from here.', 'koyel'),
        'section'           => 'koyel_grid_blogpage_options',
        'settings'          => 'koyel_grid_column_settings',
        'type'              => 'select',
        'choices'           => array(
            '6'             => esc_html__('Two Column', 'koyel'),
            '4'             => esc_html__('Three Column', 'koyel'),
        ),
    ));

	// Add koyel options section
	$wp_customize->add_section('koyel_grid_options', array(
		'title'          => __('Social Options', 'koyel-grid'),
		'capability'     => 'edit_theme_options',
		'description'    => __('Add social section options', 'koyel-grid'),
		'priority'       => 21,

	));

	// Facebook Url
    $wp_customize->add_setting('fb_url', array(
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'esc_url_raw',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('fa_url_control', array(
        'label'      => __('Facebook Url', 'koyel-grid'),
        'description'=> __('Type your facebook profile link.', 'koyel-grid'),
        'section'    => 'koyel_grid_options',
        'settings'   => 'fb_url',
        'type'       => 'url',
    ));

	// Twitter Url
    $wp_customize->add_setting('tw_url', array(
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'esc_url_raw',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('tw_url_control', array(
        'label'      => __('Twitter Url', 'koyel-grid'),
        'description'=> __('Type your twitter profile link.', 'koyel-grid'),
        'section'    => 'koyel_grid_options',
        'settings'   => 'tw_url',
        'type'       => 'url',
    ));

	// Linkedin Url
    $wp_customize->add_setting('link_url', array(
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'esc_url_raw',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('link_url_control', array(
        'label'      => __('Linkedin Url', 'koyel-grid'),
        'description'=> __('Type your linkedin profile link.', 'koyel-grid'),
        'section'    => 'koyel_grid_options',
        'settings'   => 'link_url',
        'type'       => 'url',
    ));

	// instagram Url
    $wp_customize->add_setting('instagram_url', array(
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'esc_url_raw',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('instagram_url_control', array(
        'label'      => __('Instagram Url', 'koyel-grid'),
        'description'=> __('Type your instagram profile link.', 'koyel-grid'),
        'section'    => 'koyel_grid_options',
        'settings'   => 'instagram_url',
        'type'       => 'url',
    ));
}
add_action( 'customize_register', 'koyel_grid_customize_register' );