<?php
/**
 * Koyel Grid functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Koyel Grid
 */

if ( ! defined( 'KOYEL_GRID_VERSION' ) ) {
	$koyel_grid_theme = wp_get_theme();
	define( 'KOYEL_GRID_VERSION', $koyel_grid_theme->get( 'Version' ) );
}


/**
 * Register custom fonts.
 */
function koyel_grid_fonts_url() {
    $fonts_url = '';

    $font_families = array();
    $font_families[] = 'Sora:wght@200;300;400;500;600;700;800';
    $font_families[] = 'Poppins:ital,wght@0,100;0,200;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
    $query_args = array(
        'family' => urlencode( implode( '|', $font_families ) ),
        'subset' => urlencode( 'latin,latin-ext' ),
    );

    $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    return esc_url_raw( $fonts_url );
}


/**
 * Enqueue scripts and styles.
 */
function koyel_grid_scripts() {
    wp_enqueue_style( 'koyel-grid-google-fonts', koyel_grid_fonts_url(), array(), null );
    wp_enqueue_style( 'koyel-grid-parent-style', get_template_directory_uri() . '/style.css',array('bootstrap','slicknav','koyel-default-block','koyel-style'), '', 'all');
    wp_enqueue_style( 'koyel-grid-main-style',get_stylesheet_directory_uri() . '/assets/css/main-style.css',array(), KOYEL_GRID_VERSION, 'all');
    wp_enqueue_script( 'masonry', get_stylesheet_directory_uri() . '/assets/js/masonry.pkgd.min.js', array('jquery'), '3.5.0', true );
    wp_enqueue_script( 'koyel-grid-script', get_stylesheet_directory_uri() . '/assets/js/koyel-grid-script.js', array('jquery'), KOYEL_GRID_VERSION, true );
}
add_action( 'wp_enqueue_scripts', 'koyel_grid_scripts' );

/*
 * This theme styles the visual editor to resemble the theme style,
 * specifically font, colors, and column width.
*/
add_editor_style( array(koyel_grid_fonts_url() ) ); 

/**
 * Custom excerpt length.
 */
function koyel_grid_excerpt_length( $length ) {
    if ( is_admin() ) return $length;
    return 19;
}
add_filter( 'excerpt_length', 'koyel_grid_excerpt_length', 999 );

/**
 * Custom excerpt More.
 */
function koyel_grid_excerpt_more( $more ) {
    if ( is_admin() ) return $more;
    return '.';
}
add_filter( 'excerpt_more', 'koyel_grid_excerpt_more' );

/**
 * Load Razia Photography Tags files.
 */
require get_stylesheet_directory() . '/inc/customizer.php';

/**
 * Load Razia Photography Tags files.
 */
require get_stylesheet_directory() . '/inc/template-tags.php';